package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCarrierGatewaysResponse(
    carrierGateways: Optional[Iterable[zio.aws.ec2.model.CarrierGateway]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse = {
    import DescribeCarrierGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse
      .builder()
      .optionallyWith(
        carrierGateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.carrierGateways)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeCarrierGatewaysResponse.ReadOnly =
    zio.aws.ec2.model.DescribeCarrierGatewaysResponse.wrap(buildAwsValue())
}
object DescribeCarrierGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCarrierGatewaysResponse =
      zio.aws.ec2.model.DescribeCarrierGatewaysResponse(
        carrierGateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def carrierGateways
        : Optional[List[zio.aws.ec2.model.CarrierGateway.ReadOnly]]
    def nextToken: Optional[String]
    def getCarrierGateways
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.CarrierGateway.ReadOnly]] =
      AwsError.unwrapOptionField("carrierGateways", carrierGateways)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse
  ) extends zio.aws.ec2.model.DescribeCarrierGatewaysResponse.ReadOnly {
    override val carrierGateways
        : Optional[List[zio.aws.ec2.model.CarrierGateway.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.carrierGateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CarrierGateway.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse
  ): zio.aws.ec2.model.DescribeCarrierGatewaysResponse.ReadOnly = new Wrapper(
    impl
  )
}
