package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayConnectPeerResponse(
    transitGatewayConnectPeer: Optional[
      zio.aws.ec2.model.TransitGatewayConnectPeer
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerResponse = {
    import DeleteTransitGatewayConnectPeerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerResponse
      .builder()
      .optionallyWith(
        transitGatewayConnectPeer.map(value => value.buildAwsValue())
      )(_.transitGatewayConnectPeer)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayConnectPeerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse =
      zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse(
        transitGatewayConnectPeer.map(value => value.asEditable)
      )
    def transitGatewayConnectPeer
        : Optional[zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly]
    def getTransitGatewayConnectPeer: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayConnectPeer",
      transitGatewayConnectPeer
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerResponse
  ) extends zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse.ReadOnly {
    override val transitGatewayConnectPeer
        : Optional[zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayConnectPeer())
        .map(value => zio.aws.ec2.model.TransitGatewayConnectPeer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerResponse
  ): zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse.ReadOnly =
    new Wrapper(impl)
}
