package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpnConnectionResponse(
    vpnConnection: Optional[zio.aws.ec2.model.VpnConnection] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse = {
    import CreateVpnConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse
      .builder()
      .optionallyWith(vpnConnection.map(value => value.buildAwsValue()))(
        _.vpnConnection
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly =
    zio.aws.ec2.model.CreateVpnConnectionResponse.wrap(buildAwsValue())
}
object CreateVpnConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpnConnectionResponse =
      zio.aws.ec2.model.CreateVpnConnectionResponse(
        vpnConnection.map(value => value.asEditable)
      )
    def vpnConnection: Optional[zio.aws.ec2.model.VpnConnection.ReadOnly]
    def getVpnConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnConnection.ReadOnly] =
      AwsError.unwrapOptionField("vpnConnection", vpnConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse
  ) extends zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly {
    override val vpnConnection
        : Optional[zio.aws.ec2.model.VpnConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnConnection())
        .map(value => zio.aws.ec2.model.VpnConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse
  ): zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly = new Wrapper(impl)
}
