package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcPeeringConnectionResponse(
    vpcPeeringConnection: Optional[zio.aws.ec2.model.VpcPeeringConnection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse = {
    import CreateVpcPeeringConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse
      .builder()
      .optionallyWith(vpcPeeringConnection.map(value => value.buildAwsValue()))(
        _.vpcPeeringConnection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVpcPeeringConnectionResponse.ReadOnly =
    zio.aws.ec2.model.CreateVpcPeeringConnectionResponse.wrap(buildAwsValue())
}
object CreateVpcPeeringConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpcPeeringConnectionResponse =
      zio.aws.ec2.model.CreateVpcPeeringConnectionResponse(
        vpcPeeringConnection.map(value => value.asEditable)
      )
    def vpcPeeringConnection
        : Optional[zio.aws.ec2.model.VpcPeeringConnection.ReadOnly]
    def getVpcPeeringConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcPeeringConnection.ReadOnly] =
      AwsError.unwrapOptionField("vpcPeeringConnection", vpcPeeringConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse
  ) extends zio.aws.ec2.model.CreateVpcPeeringConnectionResponse.ReadOnly {
    override val vpcPeeringConnection
        : Optional[zio.aws.ec2.model.VpcPeeringConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnection())
        .map(value => zio.aws.ec2.model.VpcPeeringConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse
  ): zio.aws.ec2.model.CreateVpcPeeringConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
