package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayResponse(
    transitGateway: Optional[zio.aws.ec2.model.TransitGateway] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayResponse = {
    import CreateTransitGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayResponse
      .builder()
      .optionallyWith(transitGateway.map(value => value.buildAwsValue()))(
        _.transitGateway
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateTransitGatewayResponse.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayResponse.wrap(buildAwsValue())
}
object CreateTransitGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTransitGatewayResponse =
      zio.aws.ec2.model.CreateTransitGatewayResponse(
        transitGateway.map(value => value.asEditable)
      )
    def transitGateway: Optional[zio.aws.ec2.model.TransitGateway.ReadOnly]
    def getTransitGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGateway.ReadOnly] =
      AwsError.unwrapOptionField("transitGateway", transitGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayResponse
  ) extends zio.aws.ec2.model.CreateTransitGatewayResponse.ReadOnly {
    override val transitGateway
        : Optional[zio.aws.ec2.model.TransitGateway.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGateway())
        .map(value => zio.aws.ec2.model.TransitGateway.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayResponse
  ): zio.aws.ec2.model.CreateTransitGatewayResponse.ReadOnly = new Wrapper(impl)
}
