package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, TrafficMirrorFilterId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTrafficMirrorFilterRuleRequest(
    trafficMirrorFilterId: TrafficMirrorFilterId,
    trafficDirection: zio.aws.ec2.model.TrafficDirection,
    ruleNumber: Integer,
    ruleAction: zio.aws.ec2.model.TrafficMirrorRuleAction,
    destinationPortRange: Optional[
      zio.aws.ec2.model.TrafficMirrorPortRangeRequest
    ] = Optional.Absent,
    sourcePortRange: Optional[zio.aws.ec2.model.TrafficMirrorPortRangeRequest] =
      Optional.Absent,
    protocol: Optional[Integer] = Optional.Absent,
    destinationCidrBlock: String,
    sourceCidrBlock: String,
    description: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest = {
    import CreateTrafficMirrorFilterRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest
      .builder()
      .trafficMirrorFilterId(
        TrafficMirrorFilterId.unwrap(trafficMirrorFilterId): java.lang.String
      )
      .trafficDirection(trafficDirection.unwrap)
      .ruleNumber(ruleNumber: java.lang.Integer)
      .ruleAction(ruleAction.unwrap)
      .optionallyWith(destinationPortRange.map(value => value.buildAwsValue()))(
        _.destinationPortRange
      )
      .optionallyWith(sourcePortRange.map(value => value.buildAwsValue()))(
        _.sourcePortRange
      )
      .optionallyWith(protocol.map(value => value: java.lang.Integer))(
        _.protocol
      )
      .destinationCidrBlock(destinationCidrBlock: java.lang.String)
      .sourceCidrBlock(sourceCidrBlock: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTrafficMirrorFilterRuleRequest.ReadOnly =
    zio.aws.ec2.model.CreateTrafficMirrorFilterRuleRequest.wrap(buildAwsValue())
}
object CreateTrafficMirrorFilterRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTrafficMirrorFilterRuleRequest =
      zio.aws.ec2.model.CreateTrafficMirrorFilterRuleRequest(
        trafficMirrorFilterId,
        trafficDirection,
        ruleNumber,
        ruleAction,
        destinationPortRange.map(value => value.asEditable),
        sourcePortRange.map(value => value.asEditable),
        protocol.map(value => value),
        destinationCidrBlock,
        sourceCidrBlock,
        description.map(value => value),
        clientToken.map(value => value)
      )
    def trafficMirrorFilterId: TrafficMirrorFilterId
    def trafficDirection: zio.aws.ec2.model.TrafficDirection
    def ruleNumber: Integer
    def ruleAction: zio.aws.ec2.model.TrafficMirrorRuleAction
    def destinationPortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly]
    def sourcePortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly]
    def protocol: Optional[Integer]
    def destinationCidrBlock: String
    def sourceCidrBlock: String
    def description: Optional[String]
    def clientToken: Optional[String]
    def getTrafficMirrorFilterId: ZIO[Any, Nothing, TrafficMirrorFilterId] =
      ZIO.succeed(trafficMirrorFilterId)
    def getTrafficDirection
        : ZIO[Any, Nothing, zio.aws.ec2.model.TrafficDirection] =
      ZIO.succeed(trafficDirection)
    def getRuleNumber: ZIO[Any, Nothing, Integer] = ZIO.succeed(ruleNumber)
    def getRuleAction
        : ZIO[Any, Nothing, zio.aws.ec2.model.TrafficMirrorRuleAction] =
      ZIO.succeed(ruleAction)
    def getDestinationPortRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly
    ] = AwsError.unwrapOptionField("destinationPortRange", destinationPortRange)
    def getSourcePortRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly
    ] = AwsError.unwrapOptionField("sourcePortRange", sourcePortRange)
    def getProtocol: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getDestinationCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationCidrBlock)
    def getSourceCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceCidrBlock)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest
  ) extends zio.aws.ec2.model.CreateTrafficMirrorFilterRuleRequest.ReadOnly {
    override val trafficMirrorFilterId: TrafficMirrorFilterId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorFilterId(impl.trafficMirrorFilterId())
    override val trafficDirection: zio.aws.ec2.model.TrafficDirection =
      zio.aws.ec2.model.TrafficDirection.wrap(impl.trafficDirection())
    override val ruleNumber: Integer = impl.ruleNumber(): Integer
    override val ruleAction: zio.aws.ec2.model.TrafficMirrorRuleAction =
      zio.aws.ec2.model.TrafficMirrorRuleAction.wrap(impl.ruleAction())
    override val destinationPortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPortRange())
        .map(value =>
          zio.aws.ec2.model.TrafficMirrorPortRangeRequest.wrap(value)
        )
    override val sourcePortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRangeRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePortRange())
        .map(value =>
          zio.aws.ec2.model.TrafficMirrorPortRangeRequest.wrap(value)
        )
    override val protocol: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => value: Integer)
    override val destinationCidrBlock: String =
      impl.destinationCidrBlock(): String
    override val sourceCidrBlock: String = impl.sourceCidrBlock(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest
  ): zio.aws.ec2.model.CreateTrafficMirrorFilterRuleRequest.ReadOnly =
    new Wrapper(impl)
}
