package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocalGatewayRouteTableVpcAssociationResponse(
    localGatewayRouteTableVpcAssociation: Optional[
      zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse = {
    import CreateLocalGatewayRouteTableVpcAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse
      .builder()
      .optionallyWith(
        localGatewayRouteTableVpcAssociation.map(value => value.buildAwsValue())
      )(_.localGatewayRouteTableVpcAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse.ReadOnly =
    zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse
      .wrap(buildAwsValue())
}
object CreateLocalGatewayRouteTableVpcAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse =
      zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse(
        localGatewayRouteTableVpcAssociation.map(value => value.asEditable)
      )
    def localGatewayRouteTableVpcAssociation: Optional[
      zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly
    ]
    def getLocalGatewayRouteTableVpcAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "localGatewayRouteTableVpcAssociation",
      localGatewayRouteTableVpcAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse
  ) extends zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse.ReadOnly {
    override val localGatewayRouteTableVpcAssociation: Optional[
      zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayRouteTableVpcAssociation())
      .map(value =>
        zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse
  ): zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
