package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudWatchLogOptions(
    logEnabled: Optional[Boolean] = Optional.Absent,
    logGroupArn: Optional[String] = Optional.Absent,
    logOutputFormat: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CloudWatchLogOptions = {
    import CloudWatchLogOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CloudWatchLogOptions
      .builder()
      .optionallyWith(logEnabled.map(value => value: java.lang.Boolean))(
        _.logEnabled
      )
      .optionallyWith(logGroupArn.map(value => value: java.lang.String))(
        _.logGroupArn
      )
      .optionallyWith(logOutputFormat.map(value => value: java.lang.String))(
        _.logOutputFormat
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CloudWatchLogOptions.ReadOnly =
    zio.aws.ec2.model.CloudWatchLogOptions.wrap(buildAwsValue())
}
object CloudWatchLogOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CloudWatchLogOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CloudWatchLogOptions =
      zio.aws.ec2.model.CloudWatchLogOptions(
        logEnabled.map(value => value),
        logGroupArn.map(value => value),
        logOutputFormat.map(value => value)
      )
    def logEnabled: Optional[Boolean]
    def logGroupArn: Optional[String]
    def logOutputFormat: Optional[String]
    def getLogEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("logEnabled", logEnabled)
    def getLogGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logGroupArn", logGroupArn)
    def getLogOutputFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logOutputFormat", logOutputFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CloudWatchLogOptions
  ) extends zio.aws.ec2.model.CloudWatchLogOptions.ReadOnly {
    override val logEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.logEnabled())
      .map(value => value: Boolean)
    override val logGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupArn())
      .map(value => value: String)
    override val logOutputFormat: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logOutputFormat())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CloudWatchLogOptions
  ): zio.aws.ec2.model.CloudWatchLogOptions.ReadOnly = new Wrapper(impl)
}
