package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CapacityReservationFleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CapacityReservationFleetCancellationState(
    currentFleetState: Optional[
      zio.aws.ec2.model.CapacityReservationFleetState
    ] = Optional.Absent,
    previousFleetState: Optional[
      zio.aws.ec2.model.CapacityReservationFleetState
    ] = Optional.Absent,
    capacityReservationFleetId: Optional[CapacityReservationFleetId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationState = {
    import CapacityReservationFleetCancellationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationState
      .builder()
      .optionallyWith(currentFleetState.map(value => value.unwrap))(
        _.currentFleetState
      )
      .optionallyWith(previousFleetState.map(value => value.unwrap))(
        _.previousFleetState
      )
      .optionallyWith(
        capacityReservationFleetId.map(value =>
          CapacityReservationFleetId.unwrap(value): java.lang.String
        )
      )(_.capacityReservationFleetId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CapacityReservationFleetCancellationState.ReadOnly =
    zio.aws.ec2.model.CapacityReservationFleetCancellationState
      .wrap(buildAwsValue())
}
object CapacityReservationFleetCancellationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CapacityReservationFleetCancellationState =
      zio.aws.ec2.model.CapacityReservationFleetCancellationState(
        currentFleetState.map(value => value),
        previousFleetState.map(value => value),
        capacityReservationFleetId.map(value => value)
      )
    def currentFleetState
        : Optional[zio.aws.ec2.model.CapacityReservationFleetState]
    def previousFleetState
        : Optional[zio.aws.ec2.model.CapacityReservationFleetState]
    def capacityReservationFleetId: Optional[CapacityReservationFleetId]
    def getCurrentFleetState
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationFleetState] =
      AwsError.unwrapOptionField("currentFleetState", currentFleetState)
    def getPreviousFleetState
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationFleetState] =
      AwsError.unwrapOptionField("previousFleetState", previousFleetState)
    def getCapacityReservationFleetId
        : ZIO[Any, AwsError, CapacityReservationFleetId] =
      AwsError.unwrapOptionField(
        "capacityReservationFleetId",
        capacityReservationFleetId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationState
  ) extends zio.aws.ec2.model.CapacityReservationFleetCancellationState.ReadOnly {
    override val currentFleetState
        : Optional[zio.aws.ec2.model.CapacityReservationFleetState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentFleetState())
        .map(value =>
          zio.aws.ec2.model.CapacityReservationFleetState.wrap(value)
        )
    override val previousFleetState
        : Optional[zio.aws.ec2.model.CapacityReservationFleetState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousFleetState())
        .map(value =>
          zio.aws.ec2.model.CapacityReservationFleetState.wrap(value)
        )
    override val capacityReservationFleetId
        : Optional[CapacityReservationFleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationFleetId())
      .map(value =>
        zio.aws.ec2.model.primitives.CapacityReservationFleetId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationState
  ): zio.aws.ec2.model.CapacityReservationFleetCancellationState.ReadOnly =
    new Wrapper(impl)
}
