package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelSpotFleetRequestsSuccessItem(
    currentSpotFleetRequestState: Optional[zio.aws.ec2.model.BatchState] =
      Optional.Absent,
    previousSpotFleetRequestState: Optional[zio.aws.ec2.model.BatchState] =
      Optional.Absent,
    spotFleetRequestId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessItem = {
    import CancelSpotFleetRequestsSuccessItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessItem
      .builder()
      .optionallyWith(currentSpotFleetRequestState.map(value => value.unwrap))(
        _.currentSpotFleetRequestState
      )
      .optionallyWith(previousSpotFleetRequestState.map(value => value.unwrap))(
        _.previousSpotFleetRequestState
      )
      .optionallyWith(spotFleetRequestId.map(value => value: java.lang.String))(
        _.spotFleetRequestId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem.ReadOnly =
    zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem.wrap(buildAwsValue())
}
object CancelSpotFleetRequestsSuccessItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem =
      zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem(
        currentSpotFleetRequestState.map(value => value),
        previousSpotFleetRequestState.map(value => value),
        spotFleetRequestId.map(value => value)
      )
    def currentSpotFleetRequestState: Optional[zio.aws.ec2.model.BatchState]
    def previousSpotFleetRequestState: Optional[zio.aws.ec2.model.BatchState]
    def spotFleetRequestId: Optional[String]
    def getCurrentSpotFleetRequestState
        : ZIO[Any, AwsError, zio.aws.ec2.model.BatchState] =
      AwsError.unwrapOptionField(
        "currentSpotFleetRequestState",
        currentSpotFleetRequestState
      )
    def getPreviousSpotFleetRequestState
        : ZIO[Any, AwsError, zio.aws.ec2.model.BatchState] =
      AwsError.unwrapOptionField(
        "previousSpotFleetRequestState",
        previousSpotFleetRequestState
      )
    def getSpotFleetRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotFleetRequestId", spotFleetRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessItem
  ) extends zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem.ReadOnly {
    override val currentSpotFleetRequestState
        : Optional[zio.aws.ec2.model.BatchState] = zio.aws.core.internal
      .optionalFromNullable(impl.currentSpotFleetRequestState())
      .map(value => zio.aws.ec2.model.BatchState.wrap(value))
    override val previousSpotFleetRequestState
        : Optional[zio.aws.ec2.model.BatchState] = zio.aws.core.internal
      .optionalFromNullable(impl.previousSpotFleetRequestState())
      .map(value => zio.aws.ec2.model.BatchState.wrap(value))
    override val spotFleetRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotFleetRequestId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessItem
  ): zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem.ReadOnly =
    new Wrapper(impl)
}
