package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceleratorCountRequest(
    min: Optional[Integer] = Optional.Absent,
    max: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceleratorCountRequest = {
    import AcceleratorCountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceleratorCountRequest
      .builder()
      .optionallyWith(min.map(value => value: java.lang.Integer))(_.min)
      .optionallyWith(max.map(value => value: java.lang.Integer))(_.max)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AcceleratorCountRequest.ReadOnly =
    zio.aws.ec2.model.AcceleratorCountRequest.wrap(buildAwsValue())
}
object AcceleratorCountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceleratorCountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceleratorCountRequest =
      zio.aws.ec2.model.AcceleratorCountRequest(
        min.map(value => value),
        max.map(value => value)
      )
    def min: Optional[Integer]
    def max: Optional[Integer]
    def getMin: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceleratorCountRequest
  ) extends zio.aws.ec2.model.AcceleratorCountRequest.ReadOnly {
    override val min: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: Integer)
    override val max: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceleratorCountRequest
  ): zio.aws.ec2.model.AcceleratorCountRequest.ReadOnly = new Wrapper(impl)
}
