package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpnTunnelLogOptions(
    cloudWatchLogOptions: Optional[zio.aws.ec2.model.CloudWatchLogOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptions = {
    import VpnTunnelLogOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptions
      .builder()
      .optionallyWith(cloudWatchLogOptions.map(value => value.buildAwsValue()))(
        _.cloudWatchLogOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnTunnelLogOptions.ReadOnly =
    zio.aws.ec2.model.VpnTunnelLogOptions.wrap(buildAwsValue())
}
object VpnTunnelLogOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnTunnelLogOptions = zio.aws.ec2.model
      .VpnTunnelLogOptions(cloudWatchLogOptions.map(value => value.asEditable))
    def cloudWatchLogOptions
        : Optional[zio.aws.ec2.model.CloudWatchLogOptions.ReadOnly]
    def getCloudWatchLogOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.CloudWatchLogOptions.ReadOnly] =
      AwsError.unwrapOptionField("cloudWatchLogOptions", cloudWatchLogOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptions
  ) extends zio.aws.ec2.model.VpnTunnelLogOptions.ReadOnly {
    override val cloudWatchLogOptions
        : Optional[zio.aws.ec2.model.CloudWatchLogOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogOptions())
        .map(value => zio.aws.ec2.model.CloudWatchLogOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptions
  ): zio.aws.ec2.model.VpnTunnelLogOptions.ReadOnly = new Wrapper(impl)
}
