package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayRouteTableId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayPolicyTableEntry(
    policyRuleNumber: Optional[String] = Optional.Absent,
    policyRule: Optional[zio.aws.ec2.model.TransitGatewayPolicyRule] =
      Optional.Absent,
    targetRouteTableId: Optional[TransitGatewayRouteTableId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableEntry = {
    import TransitGatewayPolicyTableEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableEntry
      .builder()
      .optionallyWith(policyRuleNumber.map(value => value: java.lang.String))(
        _.policyRuleNumber
      )
      .optionallyWith(policyRule.map(value => value.buildAwsValue()))(
        _.policyRule
      )
      .optionallyWith(
        targetRouteTableId.map(value =>
          TransitGatewayRouteTableId.unwrap(value): java.lang.String
        )
      )(_.targetRouteTableId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayPolicyTableEntry.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPolicyTableEntry.wrap(buildAwsValue())
}
object TransitGatewayPolicyTableEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPolicyTableEntry =
      zio.aws.ec2.model.TransitGatewayPolicyTableEntry(
        policyRuleNumber.map(value => value),
        policyRule.map(value => value.asEditable),
        targetRouteTableId.map(value => value)
      )
    def policyRuleNumber: Optional[String]
    def policyRule
        : Optional[zio.aws.ec2.model.TransitGatewayPolicyRule.ReadOnly]
    def targetRouteTableId: Optional[TransitGatewayRouteTableId]
    def getPolicyRuleNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyRuleNumber", policyRuleNumber)
    def getPolicyRule: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPolicyRule.ReadOnly
    ] = AwsError.unwrapOptionField("policyRule", policyRule)
    def getTargetRouteTableId: ZIO[Any, AwsError, TransitGatewayRouteTableId] =
      AwsError.unwrapOptionField("targetRouteTableId", targetRouteTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableEntry
  ) extends zio.aws.ec2.model.TransitGatewayPolicyTableEntry.ReadOnly {
    override val policyRuleNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyRuleNumber())
      .map(value => value: String)
    override val policyRule
        : Optional[zio.aws.ec2.model.TransitGatewayPolicyRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRule())
        .map(value => zio.aws.ec2.model.TransitGatewayPolicyRule.wrap(value))
    override val targetRouteTableId: Optional[TransitGatewayRouteTableId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetRouteTableId())
        .map(value =>
          zio.aws.ec2.model.primitives.TransitGatewayRouteTableId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableEntry
  ): zio.aws.ec2.model.TransitGatewayPolicyTableEntry.ReadOnly = new Wrapper(
    impl
  )
}
