package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayMulticastRegisteredGroupSources(
    transitGatewayMulticastDomainId: Optional[String] = Optional.Absent,
    registeredNetworkInterfaceIds: Optional[Iterable[String]] = Optional.Absent,
    groupIpAddress: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastRegisteredGroupSources = {
    import TransitGatewayMulticastRegisteredGroupSources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastRegisteredGroupSources
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value => value: java.lang.String)
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(
        registeredNetworkInterfaceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.registeredNetworkInterfaceIds)
      .optionallyWith(groupIpAddress.map(value => value: java.lang.String))(
        _.groupIpAddress
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources.ReadOnly =
    zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources
      .wrap(buildAwsValue())
}
object TransitGatewayMulticastRegisteredGroupSources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastRegisteredGroupSources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources =
      zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources(
        transitGatewayMulticastDomainId.map(value => value),
        registeredNetworkInterfaceIds.map(value => value),
        groupIpAddress.map(value => value)
      )
    def transitGatewayMulticastDomainId: Optional[String]
    def registeredNetworkInterfaceIds: Optional[List[String]]
    def groupIpAddress: Optional[String]
    def getTransitGatewayMulticastDomainId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getRegisteredNetworkInterfaceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "registeredNetworkInterfaceIds",
        registeredNetworkInterfaceIds
      )
    def getGroupIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIpAddress", groupIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastRegisteredGroupSources
  ) extends zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources.ReadOnly {
    override val transitGatewayMulticastDomainId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayMulticastDomainId())
        .map(value => value: String)
    override val registeredNetworkInterfaceIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registeredNetworkInterfaceIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val groupIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIpAddress())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastRegisteredGroupSources
  ): zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources.ReadOnly =
    new Wrapper(impl)
}
