package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupName,
  SecurityGroupId,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RevokeSecurityGroupIngressRequest(
    cidrIp: Optional[String] = Optional.Absent,
    fromPort: Optional[Integer] = Optional.Absent,
    groupId: Optional[SecurityGroupId] = Optional.Absent,
    groupName: Optional[SecurityGroupName] = Optional.Absent,
    ipPermissions: Optional[Iterable[zio.aws.ec2.model.IpPermission]] =
      Optional.Absent,
    ipProtocol: Optional[String] = Optional.Absent,
    sourceSecurityGroupName: Optional[String] = Optional.Absent,
    sourceSecurityGroupOwnerId: Optional[String] = Optional.Absent,
    toPort: Optional[Integer] = Optional.Absent,
    securityGroupRuleIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest = {
    import RevokeSecurityGroupIngressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest
      .builder()
      .optionallyWith(cidrIp.map(value => value: java.lang.String))(_.cidrIp)
      .optionallyWith(fromPort.map(value => value: java.lang.Integer))(
        _.fromPort
      )
      .optionallyWith(
        groupId.map(value => SecurityGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value =>
          SecurityGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(
        sourceSecurityGroupName.map(value => value: java.lang.String)
      )(_.sourceSecurityGroupName)
      .optionallyWith(
        sourceSecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.sourceSecurityGroupOwnerId)
      .optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort)
      .optionallyWith(
        securityGroupRuleIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupRuleIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RevokeSecurityGroupIngressRequest.ReadOnly =
    zio.aws.ec2.model.RevokeSecurityGroupIngressRequest.wrap(buildAwsValue())
}
object RevokeSecurityGroupIngressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RevokeSecurityGroupIngressRequest =
      zio.aws.ec2.model.RevokeSecurityGroupIngressRequest(
        cidrIp.map(value => value),
        fromPort.map(value => value),
        groupId.map(value => value),
        groupName.map(value => value),
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipProtocol.map(value => value),
        sourceSecurityGroupName.map(value => value),
        sourceSecurityGroupOwnerId.map(value => value),
        toPort.map(value => value),
        securityGroupRuleIds.map(value => value)
      )
    def cidrIp: Optional[String]
    def fromPort: Optional[Integer]
    def groupId: Optional[SecurityGroupId]
    def groupName: Optional[SecurityGroupName]
    def ipPermissions: Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def ipProtocol: Optional[String]
    def sourceSecurityGroupName: Optional[String]
    def sourceSecurityGroupOwnerId: Optional[String]
    def toPort: Optional[Integer]
    def securityGroupRuleIds: Optional[List[String]]
    def getCidrIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIp", cidrIp)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, SecurityGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getSourceSecurityGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceSecurityGroupName", sourceSecurityGroupName)
    def getSourceSecurityGroupOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceSecurityGroupOwnerId",
        sourceSecurityGroupOwnerId
      )
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getSecurityGroupRuleIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupRuleIds", securityGroupRuleIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest
  ) extends zio.aws.ec2.model.RevokeSecurityGroupIngressRequest.ReadOnly {
    override val cidrIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrIp())
      .map(value => value: String)
    override val fromPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => value: Integer)
    override val groupId: Optional[SecurityGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupId(value))
    override val groupName: Optional[SecurityGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupName(value))
    override val ipPermissions
        : Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpPermission.wrap(item)
          }.toList
        )
    override val ipProtocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipProtocol())
      .map(value => value: String)
    override val sourceSecurityGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceSecurityGroupName())
        .map(value => value: String)
    override val sourceSecurityGroupOwnerId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceSecurityGroupOwnerId())
        .map(value => value: String)
    override val toPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => value: Integer)
    override val securityGroupRuleIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupRuleIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest
  ): zio.aws.ec2.model.RevokeSecurityGroupIngressRequest.ReadOnly = new Wrapper(
    impl
  )
}
