package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Phase1EncryptionAlgorithmsRequestListValue(
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsRequestListValue = {
    import Phase1EncryptionAlgorithmsRequestListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsRequestListValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue.ReadOnly =
    zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue
      .wrap(buildAwsValue())
}
object Phase1EncryptionAlgorithmsRequestListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsRequestListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue =
      zio.aws.ec2.model
        .Phase1EncryptionAlgorithmsRequestListValue(value.map(value => value))
    def value: Optional[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsRequestListValue
  ) extends zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsRequestListValue
  ): zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue.ReadOnly =
    new Wrapper(impl)
}
