package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyIpamResourceCidrResponse(
    ipamResourceCidr: Optional[zio.aws.ec2.model.IpamResourceCidr] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrResponse = {
    import ModifyIpamResourceCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrResponse
      .builder()
      .optionallyWith(ipamResourceCidr.map(value => value.buildAwsValue()))(
        _.ipamResourceCidr
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIpamResourceCidrResponse.ReadOnly =
    zio.aws.ec2.model.ModifyIpamResourceCidrResponse.wrap(buildAwsValue())
}
object ModifyIpamResourceCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIpamResourceCidrResponse =
      zio.aws.ec2.model.ModifyIpamResourceCidrResponse(
        ipamResourceCidr.map(value => value.asEditable)
      )
    def ipamResourceCidr: Optional[zio.aws.ec2.model.IpamResourceCidr.ReadOnly]
    def getIpamResourceCidr
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamResourceCidr.ReadOnly] =
      AwsError.unwrapOptionField("ipamResourceCidr", ipamResourceCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrResponse
  ) extends zio.aws.ec2.model.ModifyIpamResourceCidrResponse.ReadOnly {
    override val ipamResourceCidr
        : Optional[zio.aws.ec2.model.IpamResourceCidr.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceCidr())
        .map(value => zio.aws.ec2.model.IpamResourceCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrResponse
  ): zio.aws.ec2.model.ModifyIpamResourceCidrResponse.ReadOnly = new Wrapper(
    impl
  )
}
