package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyInstanceMetadataOptionsResponse(
    instanceId: Optional[String] = Optional.Absent,
    instanceMetadataOptions: Optional[
      zio.aws.ec2.model.InstanceMetadataOptionsResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsResponse = {
    import ModifyInstanceMetadataOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsResponse
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(
        instanceMetadataOptions.map(value => value.buildAwsValue())
      )(_.instanceMetadataOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse
      .wrap(buildAwsValue())
}
object ModifyInstanceMetadataOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse =
      zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse(
        instanceId.map(value => value),
        instanceMetadataOptions.map(value => value.asEditable)
      )
    def instanceId: Optional[String]
    def instanceMetadataOptions
        : Optional[zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceMetadataOptions",
      instanceMetadataOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsResponse
  ) extends zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse.ReadOnly {
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val instanceMetadataOptions
        : Optional[zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMetadataOptions())
        .map(value =>
          zio.aws.ec2.model.InstanceMetadataOptionsResponse.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsResponse
  ): zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
