package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DateTime,
  VersionDescription,
  LaunchTemplateName
}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateVersion(
    launchTemplateId: Optional[String] = Optional.Absent,
    launchTemplateName: Optional[LaunchTemplateName] = Optional.Absent,
    versionNumber: Optional[Long] = Optional.Absent,
    versionDescription: Optional[VersionDescription] = Optional.Absent,
    createTime: Optional[DateTime] = Optional.Absent,
    createdBy: Optional[String] = Optional.Absent,
    defaultVersion: Optional[Boolean] = Optional.Absent,
    launchTemplateData: Optional[zio.aws.ec2.model.ResponseLaunchTemplateData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion = {
    import LaunchTemplateVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion
      .builder()
      .optionallyWith(launchTemplateId.map(value => value: java.lang.String))(
        _.launchTemplateId
      )
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(versionNumber.map(value => value: java.lang.Long))(
        _.versionNumber
      )
      .optionallyWith(
        versionDescription.map(value =>
          VersionDescription.unwrap(value): java.lang.String
        )
      )(_.versionDescription)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(defaultVersion.map(value => value: java.lang.Boolean))(
        _.defaultVersion
      )
      .optionallyWith(launchTemplateData.map(value => value.buildAwsValue()))(
        _.launchTemplateData
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateVersion.wrap(buildAwsValue())
}
object LaunchTemplateVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateVersion =
      zio.aws.ec2.model.LaunchTemplateVersion(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        versionNumber.map(value => value),
        versionDescription.map(value => value),
        createTime.map(value => value),
        createdBy.map(value => value),
        defaultVersion.map(value => value),
        launchTemplateData.map(value => value.asEditable)
      )
    def launchTemplateId: Optional[String]
    def launchTemplateName: Optional[LaunchTemplateName]
    def versionNumber: Optional[Long]
    def versionDescription: Optional[VersionDescription]
    def createTime: Optional[DateTime]
    def createdBy: Optional[String]
    def defaultVersion: Optional[Boolean]
    def launchTemplateData
        : Optional[zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly]
    def getLaunchTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getVersionDescription: ZIO[Any, AwsError, VersionDescription] =
      AwsError.unwrapOptionField("versionDescription", versionDescription)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDefaultVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultVersion", defaultVersion)
    def getLaunchTemplateData: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplateData", launchTemplateData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion
  ) extends zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly {
    override val launchTemplateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateId())
      .map(value => value: String)
    override val launchTemplateName: Optional[LaunchTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateName())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val versionNumber: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.versionNumber())
      .map(value => value: Long)
    override val versionDescription: Optional[VersionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionDescription())
        .map(value => zio.aws.ec2.model.primitives.VersionDescription(value))
    override val createTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val defaultVersion: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultVersion())
      .map(value => value: Boolean)
    override val launchTemplateData
        : Optional[zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateData())
        .map(value => zio.aws.ec2.model.ResponseLaunchTemplateData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion
  ): zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly = new Wrapper(impl)
}
