package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Ipv6Range(
    cidrIpv6: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Ipv6Range = {
    import Ipv6Range.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ipv6Range
      .builder()
      .optionallyWith(cidrIpv6.map(value => value: java.lang.String))(
        _.cidrIpv6
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ipv6Range.ReadOnly =
    zio.aws.ec2.model.Ipv6Range.wrap(buildAwsValue())
}
object Ipv6Range {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Ipv6Range] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ipv6Range = zio.aws.ec2.model
      .Ipv6Range(cidrIpv6.map(value => value), description.map(value => value))
    def cidrIpv6: Optional[String]
    def description: Optional[String]
    def getCidrIpv6: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIpv6", cidrIpv6)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6Range
  ) extends zio.aws.ec2.model.Ipv6Range.ReadOnly {
    override val cidrIpv6: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrIpv6())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6Range
  ): zio.aws.ec2.model.Ipv6Range.ReadOnly = new Wrapper(impl)
}
