package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DedicatedHostId, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceEventWindowDisassociationRequest(
    instanceIds: Optional[Iterable[InstanceId]] = Optional.Absent,
    instanceTags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    dedicatedHostIds: Optional[Iterable[DedicatedHostId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceEventWindowDisassociationRequest = {
    import InstanceEventWindowDisassociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowDisassociationRequest
      .builder()
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(
        instanceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTags)
      .optionallyWith(
        dedicatedHostIds.map(value =>
          value.map { item =>
            DedicatedHostId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dedicatedHostIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceEventWindowDisassociationRequest.ReadOnly =
    zio.aws.ec2.model.InstanceEventWindowDisassociationRequest
      .wrap(buildAwsValue())
}
object InstanceEventWindowDisassociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowDisassociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceEventWindowDisassociationRequest =
      zio.aws.ec2.model.InstanceEventWindowDisassociationRequest(
        instanceIds.map(value => value),
        instanceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dedicatedHostIds.map(value => value)
      )
    def instanceIds: Optional[List[InstanceId]]
    def instanceTags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def dedicatedHostIds: Optional[List[DedicatedHostId]]
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getInstanceTags
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("instanceTags", instanceTags)
    def getDedicatedHostIds: ZIO[Any, AwsError, List[DedicatedHostId]] =
      AwsError.unwrapOptionField("dedicatedHostIds", dedicatedHostIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowDisassociationRequest
  ) extends zio.aws.ec2.model.InstanceEventWindowDisassociationRequest.ReadOnly {
    override val instanceIds: Optional[List[InstanceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.InstanceId(item)
        }.toList
      )
    override val instanceTags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val dedicatedHostIds: Optional[List[DedicatedHostId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedHostIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.DedicatedHostId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowDisassociationRequest
  ): zio.aws.ec2.model.InstanceEventWindowDisassociationRequest.ReadOnly =
    new Wrapper(impl)
}
