package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  OfferingId,
  HostReservationId,
  DateTime,
  Integer
}
import scala.jdk.CollectionConverters._
final case class HostReservation(
    count: Optional[Integer] = Optional.Absent,
    currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    end: Optional[DateTime] = Optional.Absent,
    hostIdSet: Optional[Iterable[String]] = Optional.Absent,
    hostReservationId: Optional[HostReservationId] = Optional.Absent,
    hourlyPrice: Optional[String] = Optional.Absent,
    instanceFamily: Optional[String] = Optional.Absent,
    offeringId: Optional[OfferingId] = Optional.Absent,
    paymentOption: Optional[zio.aws.ec2.model.PaymentOption] = Optional.Absent,
    start: Optional[DateTime] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.ReservationState] = Optional.Absent,
    upfrontPrice: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HostReservation = {
    import HostReservation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HostReservation
      .builder()
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(end.map(value => DateTime.unwrap(value): Instant))(_.end)
      .optionallyWith(
        hostIdSet.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.hostIdSet)
      .optionallyWith(
        hostReservationId.map(value =>
          HostReservationId.unwrap(value): java.lang.String
        )
      )(_.hostReservationId)
      .optionallyWith(hourlyPrice.map(value => value: java.lang.String))(
        _.hourlyPrice
      )
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .optionallyWith(
        offeringId.map(value => OfferingId.unwrap(value): java.lang.String)
      )(_.offeringId)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(start.map(value => DateTime.unwrap(value): Instant))(
        _.start
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(upfrontPrice.map(value => value: java.lang.String))(
        _.upfrontPrice
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HostReservation.ReadOnly =
    zio.aws.ec2.model.HostReservation.wrap(buildAwsValue())
}
object HostReservation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.HostReservation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HostReservation =
      zio.aws.ec2.model.HostReservation(
        count.map(value => value),
        currencyCode.map(value => value),
        duration.map(value => value),
        end.map(value => value),
        hostIdSet.map(value => value),
        hostReservationId.map(value => value),
        hourlyPrice.map(value => value),
        instanceFamily.map(value => value),
        offeringId.map(value => value),
        paymentOption.map(value => value),
        start.map(value => value),
        state.map(value => value),
        upfrontPrice.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def count: Optional[Integer]
    def currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues]
    def duration: Optional[Integer]
    def end: Optional[DateTime]
    def hostIdSet: Optional[List[String]]
    def hostReservationId: Optional[HostReservationId]
    def hourlyPrice: Optional[String]
    def instanceFamily: Optional[String]
    def offeringId: Optional[OfferingId]
    def paymentOption: Optional[zio.aws.ec2.model.PaymentOption]
    def start: Optional[DateTime]
    def state: Optional[zio.aws.ec2.model.ReservationState]
    def upfrontPrice: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getEnd: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("end", end)
    def getHostIdSet: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("hostIdSet", hostIdSet)
    def getHostReservationId: ZIO[Any, AwsError, HostReservationId] =
      AwsError.unwrapOptionField("hostReservationId", hostReservationId)
    def getHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hourlyPrice", hourlyPrice)
    def getInstanceFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamily)
    def getOfferingId: ZIO[Any, AwsError, OfferingId] =
      AwsError.unwrapOptionField("offeringId", offeringId)
    def getPaymentOption: ZIO[Any, AwsError, zio.aws.ec2.model.PaymentOption] =
      AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getStart: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("start", start)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ReservationState] =
      AwsError.unwrapOptionField("state", state)
    def getUpfrontPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("upfrontPrice", upfrontPrice)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HostReservation
  ) extends zio.aws.ec2.model.HostReservation.ReadOnly {
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
    override val currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val end: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val hostIdSet: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.hostIdSet())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val hostReservationId: Optional[HostReservationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostReservationId())
        .map(value => zio.aws.ec2.model.primitives.HostReservationId(value))
    override val hourlyPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hourlyPrice())
      .map(value => value: String)
    override val instanceFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceFamily())
      .map(value => value: String)
    override val offeringId: Optional[OfferingId] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringId())
      .map(value => zio.aws.ec2.model.primitives.OfferingId(value))
    override val paymentOption: Optional[zio.aws.ec2.model.PaymentOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paymentOption())
        .map(value => zio.aws.ec2.model.PaymentOption.wrap(value))
    override val start: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val state: Optional[zio.aws.ec2.model.ReservationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.ReservationState.wrap(value))
    override val upfrontPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.upfrontPrice())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HostReservation
  ): zio.aws.ec2.model.HostReservation.ReadOnly = new Wrapper(impl)
}
