package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  GetIpamPoolAllocationsMaxResults,
  IpamPoolAllocationId,
  IpamPoolId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetIpamPoolAllocationsRequest(
    ipamPoolId: IpamPoolId,
    ipamPoolAllocationId: Optional[IpamPoolAllocationId] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[GetIpamPoolAllocationsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest = {
    import GetIpamPoolAllocationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest
      .builder()
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .optionallyWith(
        ipamPoolAllocationId.map(value =>
          IpamPoolAllocationId.unwrap(value): java.lang.String
        )
      )(_.ipamPoolAllocationId)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          GetIpamPoolAllocationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamPoolAllocationsRequest.ReadOnly =
    zio.aws.ec2.model.GetIpamPoolAllocationsRequest.wrap(buildAwsValue())
}
object GetIpamPoolAllocationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamPoolAllocationsRequest =
      zio.aws.ec2.model.GetIpamPoolAllocationsRequest(
        ipamPoolId,
        ipamPoolAllocationId.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def ipamPoolId: IpamPoolId
    def ipamPoolAllocationId: Optional[IpamPoolAllocationId]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[GetIpamPoolAllocationsMaxResults]
    def nextToken: Optional[NextToken]
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getIpamPoolAllocationId: ZIO[Any, AwsError, IpamPoolAllocationId] =
      AwsError.unwrapOptionField("ipamPoolAllocationId", ipamPoolAllocationId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, GetIpamPoolAllocationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest
  ) extends zio.aws.ec2.model.GetIpamPoolAllocationsRequest.ReadOnly {
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val ipamPoolAllocationId: Optional[IpamPoolAllocationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamPoolAllocationId())
        .map(value => zio.aws.ec2.model.primitives.IpamPoolAllocationId(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[GetIpamPoolAllocationsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.GetIpamPoolAllocationsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest
  ): zio.aws.ec2.model.GetIpamPoolAllocationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
