package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetConsoleOutputRequest(
    instanceId: InstanceId,
    latest: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest = {
    import GetConsoleOutputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(latest.map(value => value: java.lang.Boolean))(_.latest)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetConsoleOutputRequest.ReadOnly =
    zio.aws.ec2.model.GetConsoleOutputRequest.wrap(buildAwsValue())
}
object GetConsoleOutputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetConsoleOutputRequest =
      zio.aws.ec2.model
        .GetConsoleOutputRequest(instanceId, latest.map(value => value))
    def instanceId: InstanceId
    def latest: Optional[Boolean]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getLatest: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("latest", latest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest
  ) extends zio.aws.ec2.model.GetConsoleOutputRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val latest: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.latest())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest
  ): zio.aws.ec2.model.GetConsoleOutputRequest.ReadOnly = new Wrapper(impl)
}
