package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DiskImage(
    description: Optional[String] = Optional.Absent,
    image: Optional[zio.aws.ec2.model.DiskImageDetail] = Optional.Absent,
    volume: Optional[zio.aws.ec2.model.VolumeDetail] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.DiskImage = {
    import DiskImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DiskImage
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(image.map(value => value.buildAwsValue()))(_.image)
      .optionallyWith(volume.map(value => value.buildAwsValue()))(_.volume)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DiskImage.ReadOnly =
    zio.aws.ec2.model.DiskImage.wrap(buildAwsValue())
}
object DiskImage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.DiskImage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DiskImage = zio.aws.ec2.model.DiskImage(
      description.map(value => value),
      image.map(value => value.asEditable),
      volume.map(value => value.asEditable)
    )
    def description: Optional[String]
    def image: Optional[zio.aws.ec2.model.DiskImageDetail.ReadOnly]
    def volume: Optional[zio.aws.ec2.model.VolumeDetail.ReadOnly]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImage
        : ZIO[Any, AwsError, zio.aws.ec2.model.DiskImageDetail.ReadOnly] =
      AwsError.unwrapOptionField("image", image)
    def getVolume: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeDetail.ReadOnly] =
      AwsError.unwrapOptionField("volume", volume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DiskImage
  ) extends zio.aws.ec2.model.DiskImage.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val image: Optional[zio.aws.ec2.model.DiskImageDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.image())
        .map(value => zio.aws.ec2.model.DiskImageDetail.wrap(value))
    override val volume: Optional[zio.aws.ec2.model.VolumeDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volume())
        .map(value => zio.aws.ec2.model.VolumeDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DiskImage
  ): zio.aws.ec2.model.DiskImage.ReadOnly = new Wrapper(impl)
}
