package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayPolicyTableId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateTransitGatewayPolicyTableRequest(
    transitGatewayPolicyTableId: TransitGatewayPolicyTableId,
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest = {
    import DisassociateTransitGatewayPolicyTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest
      .builder()
      .transitGatewayPolicyTableId(
        TransitGatewayPolicyTableId.unwrap(
          transitGatewayPolicyTableId
        ): java.lang.String
      )
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest
      .wrap(buildAwsValue())
}
object DisassociateTransitGatewayPolicyTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest =
      zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest(
        transitGatewayPolicyTableId,
        transitGatewayAttachmentId
      )
    def transitGatewayPolicyTableId: TransitGatewayPolicyTableId
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayPolicyTableId
        : ZIO[Any, Nothing, TransitGatewayPolicyTableId] =
      ZIO.succeed(transitGatewayPolicyTableId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest
  ) extends zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest.ReadOnly {
    override val transitGatewayPolicyTableId: TransitGatewayPolicyTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayPolicyTableId(impl.transitGatewayPolicyTableId())
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest
  ): zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest.ReadOnly =
    new Wrapper(impl)
}
