package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeTrunkInterfaceAssociationsMaxResults,
  TrunkInterfaceAssociationId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeTrunkInterfaceAssociationsRequest(
    associationIds: Optional[Iterable[TrunkInterfaceAssociationId]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeTrunkInterfaceAssociationsMaxResults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest = {
    import DescribeTrunkInterfaceAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest
      .builder()
      .optionallyWith(
        associationIds.map(value =>
          value.map { item =>
            TrunkInterfaceAssociationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associationIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeTrunkInterfaceAssociationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeTrunkInterfaceAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest =
      zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest(
        associationIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def associationIds: Optional[List[TrunkInterfaceAssociationId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeTrunkInterfaceAssociationsMaxResults]
    def getAssociationIds
        : ZIO[Any, AwsError, List[TrunkInterfaceAssociationId]] =
      AwsError.unwrapOptionField("associationIds", associationIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeTrunkInterfaceAssociationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest
  ) extends zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest.ReadOnly {
    override val associationIds: Optional[List[TrunkInterfaceAssociationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.TrunkInterfaceAssociationId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults
        : Optional[DescribeTrunkInterfaceAssociationsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeTrunkInterfaceAssociationsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest
  ): zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
