package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSpotFleetInstancesResponse(
    activeInstances: Optional[Iterable[zio.aws.ec2.model.ActiveInstance]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    spotFleetRequestId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse = {
    import DescribeSpotFleetInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse
      .builder()
      .optionallyWith(
        activeInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeInstances)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(spotFleetRequestId.map(value => value: java.lang.String))(
        _.spotFleetRequestId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.wrap(buildAwsValue())
}
object DescribeSpotFleetInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotFleetInstancesResponse =
      zio.aws.ec2.model.DescribeSpotFleetInstancesResponse(
        activeInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        spotFleetRequestId.map(value => value)
      )
    def activeInstances
        : Optional[List[zio.aws.ec2.model.ActiveInstance.ReadOnly]]
    def nextToken: Optional[String]
    def spotFleetRequestId: Optional[String]
    def getActiveInstances
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ActiveInstance.ReadOnly]] =
      AwsError.unwrapOptionField("activeInstances", activeInstances)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSpotFleetRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotFleetRequestId", spotFleetRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse
  ) extends zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly {
    override val activeInstances
        : Optional[List[zio.aws.ec2.model.ActiveInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ActiveInstance.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val spotFleetRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotFleetRequestId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse
  ): zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
