package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ReservedInstancesModificationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstancesModificationsRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    reservedInstancesModificationIds: Optional[
      Iterable[ReservedInstancesModificationId]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest = {
    import DescribeReservedInstancesModificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        reservedInstancesModificationIds.map(value =>
          value.map { item =>
            ReservedInstancesModificationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.reservedInstancesModificationIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedInstancesModificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest =
      zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedInstancesModificationIds.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def reservedInstancesModificationIds
        : Optional[List[ReservedInstancesModificationId]]
    def nextToken: Optional[String]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getReservedInstancesModificationIds
        : ZIO[Any, AwsError, List[ReservedInstancesModificationId]] =
      AwsError.unwrapOptionField(
        "reservedInstancesModificationIds",
        reservedInstancesModificationIds
      )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest
  ) extends zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val reservedInstancesModificationIds
        : Optional[List[ReservedInstancesModificationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstancesModificationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ReservedInstancesModificationId(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest
  ): zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest.ReadOnly =
    new Wrapper(impl)
}
