package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{PlacementGroupId, PlacementGroupName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePlacementGroupsRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    groupNames: Optional[Iterable[PlacementGroupName]] = Optional.Absent,
    groupIds: Optional[Iterable[PlacementGroupId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest = {
    import DescribePlacementGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        groupNames.map(value =>
          value.map { item =>
            PlacementGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupNames)
      .optionallyWith(
        groupIds.map(value =>
          value.map { item =>
            PlacementGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePlacementGroupsRequest.ReadOnly =
    zio.aws.ec2.model.DescribePlacementGroupsRequest.wrap(buildAwsValue())
}
object DescribePlacementGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePlacementGroupsRequest =
      zio.aws.ec2.model.DescribePlacementGroupsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupNames.map(value => value),
        groupIds.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def groupNames: Optional[List[PlacementGroupName]]
    def groupIds: Optional[List[PlacementGroupId]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getGroupNames: ZIO[Any, AwsError, List[PlacementGroupName]] =
      AwsError.unwrapOptionField("groupNames", groupNames)
    def getGroupIds: ZIO[Any, AwsError, List[PlacementGroupId]] =
      AwsError.unwrapOptionField("groupIds", groupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest
  ) extends zio.aws.ec2.model.DescribePlacementGroupsRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val groupNames: Optional[List[PlacementGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.PlacementGroupName(item)
          }.toList
        )
    override val groupIds: Optional[List[PlacementGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.PlacementGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest
  ): zio.aws.ec2.model.DescribePlacementGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
