package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeImportSnapshotTasksResponse(
    importSnapshotTasks: Optional[
      Iterable[zio.aws.ec2.model.ImportSnapshotTask]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse = {
    import DescribeImportSnapshotTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse
      .builder()
      .optionallyWith(
        importSnapshotTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importSnapshotTasks)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly =
    zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.wrap(buildAwsValue())
}
object DescribeImportSnapshotTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImportSnapshotTasksResponse =
      zio.aws.ec2.model.DescribeImportSnapshotTasksResponse(
        importSnapshotTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def importSnapshotTasks
        : Optional[List[zio.aws.ec2.model.ImportSnapshotTask.ReadOnly]]
    def nextToken: Optional[String]
    def getImportSnapshotTasks: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImportSnapshotTask.ReadOnly
    ]] = AwsError.unwrapOptionField("importSnapshotTasks", importSnapshotTasks)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse
  ) extends zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly {
    override val importSnapshotTasks
        : Optional[List[zio.aws.ec2.model.ImportSnapshotTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importSnapshotTasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ImportSnapshotTask.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse
  ): zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly =
    new Wrapper(impl)
}
