package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{FleetId, DateTime}
import scala.jdk.CollectionConverters._
final case class DescribeFleetHistoryResponse(
    historyRecords: Optional[Iterable[zio.aws.ec2.model.HistoryRecordEntry]] =
      Optional.Absent,
    lastEvaluatedTime: Optional[DateTime] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    fleetId: Optional[FleetId] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryResponse = {
    import DescribeFleetHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryResponse
      .builder()
      .optionallyWith(
        historyRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.historyRecords)
      .optionallyWith(
        lastEvaluatedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastEvaluatedTime)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly =
    zio.aws.ec2.model.DescribeFleetHistoryResponse.wrap(buildAwsValue())
}
object DescribeFleetHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFleetHistoryResponse =
      zio.aws.ec2.model.DescribeFleetHistoryResponse(
        historyRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastEvaluatedTime.map(value => value),
        nextToken.map(value => value),
        fleetId.map(value => value),
        startTime.map(value => value)
      )
    def historyRecords
        : Optional[List[zio.aws.ec2.model.HistoryRecordEntry.ReadOnly]]
    def lastEvaluatedTime: Optional[DateTime]
    def nextToken: Optional[String]
    def fleetId: Optional[FleetId]
    def startTime: Optional[DateTime]
    def getHistoryRecords: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.HistoryRecordEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("historyRecords", historyRecords)
    def getLastEvaluatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastEvaluatedTime", lastEvaluatedTime)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryResponse
  ) extends zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly {
    override val historyRecords
        : Optional[List[zio.aws.ec2.model.HistoryRecordEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.historyRecords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.HistoryRecordEntry.wrap(item)
          }.toList
        )
    override val lastEvaluatedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastEvaluatedTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.ec2.model.primitives.FleetId(value))
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryResponse
  ): zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly = new Wrapper(impl)
}
