package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayPeeringAttachmentResponse(
    transitGatewayPeeringAttachment: Optional[
      zio.aws.ec2.model.TransitGatewayPeeringAttachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse = {
    import DeleteTransitGatewayPeeringAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse
      .builder()
      .optionallyWith(
        transitGatewayPeeringAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayPeeringAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayPeeringAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse =
      zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse(
        transitGatewayPeeringAttachment.map(value => value.asEditable)
      )
    def transitGatewayPeeringAttachment
        : Optional[zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly]
    def getTransitGatewayPeeringAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayPeeringAttachment",
      transitGatewayPeeringAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse
  ) extends zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse.ReadOnly {
    override val transitGatewayPeeringAttachment
        : Optional[zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayPeeringAttachment())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayPeeringAttachment.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse
  ): zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
