package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ReservationId, Integer}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateReservedInstancesListingRequest(
    clientToken: String,
    instanceCount: Integer,
    priceSchedules: Iterable[zio.aws.ec2.model.PriceScheduleSpecification],
    reservedInstancesId: ReservationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest = {
    import CreateReservedInstancesListingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest
      .builder()
      .clientToken(clientToken: java.lang.String)
      .instanceCount(instanceCount: java.lang.Integer)
      .priceSchedules(priceSchedules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .reservedInstancesId(
        ReservationId.unwrap(reservedInstancesId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateReservedInstancesListingRequest.ReadOnly =
    zio.aws.ec2.model.CreateReservedInstancesListingRequest
      .wrap(buildAwsValue())
}
object CreateReservedInstancesListingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateReservedInstancesListingRequest =
      zio.aws.ec2.model.CreateReservedInstancesListingRequest(
        clientToken,
        instanceCount,
        priceSchedules.map { item =>
          item.asEditable
        },
        reservedInstancesId
      )
    def clientToken: String
    def instanceCount: Integer
    def priceSchedules
        : List[zio.aws.ec2.model.PriceScheduleSpecification.ReadOnly]
    def reservedInstancesId: ReservationId
    def getClientToken: ZIO[Any, Nothing, String] = ZIO.succeed(clientToken)
    def getInstanceCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(instanceCount)
    def getPriceSchedules: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.PriceScheduleSpecification.ReadOnly
    ]] = ZIO.succeed(priceSchedules)
    def getReservedInstancesId: ZIO[Any, Nothing, ReservationId] =
      ZIO.succeed(reservedInstancesId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest
  ) extends zio.aws.ec2.model.CreateReservedInstancesListingRequest.ReadOnly {
    override val clientToken: String = impl.clientToken(): String
    override val instanceCount: Integer = impl.instanceCount(): Integer
    override val priceSchedules
        : List[zio.aws.ec2.model.PriceScheduleSpecification.ReadOnly] = impl
      .priceSchedules()
      .asScala
      .map { item =>
        zio.aws.ec2.model.PriceScheduleSpecification.wrap(item)
      }
      .toList
    override val reservedInstancesId: ReservationId =
      zio.aws.ec2.model.primitives.ReservationId(impl.reservedInstancesId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest
  ): zio.aws.ec2.model.CreateReservedInstancesListingRequest.ReadOnly =
    new Wrapper(impl)
}
