package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccessScopePath(
    source: Optional[zio.aws.ec2.model.PathStatement] = Optional.Absent,
    destination: Optional[zio.aws.ec2.model.PathStatement] = Optional.Absent,
    throughResources: Optional[
      Iterable[zio.aws.ec2.model.ThroughResourcesStatement]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AccessScopePath = {
    import AccessScopePath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AccessScopePath
      .builder()
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        throughResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.throughResources)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AccessScopePath.ReadOnly =
    zio.aws.ec2.model.AccessScopePath.wrap(buildAwsValue())
}
object AccessScopePath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AccessScopePath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AccessScopePath =
      zio.aws.ec2.model.AccessScopePath(
        source.map(value => value.asEditable),
        destination.map(value => value.asEditable),
        throughResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def source: Optional[zio.aws.ec2.model.PathStatement.ReadOnly]
    def destination: Optional[zio.aws.ec2.model.PathStatement.ReadOnly]
    def throughResources
        : Optional[List[zio.aws.ec2.model.ThroughResourcesStatement.ReadOnly]]
    def getSource
        : ZIO[Any, AwsError, zio.aws.ec2.model.PathStatement.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.ec2.model.PathStatement.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getThroughResources: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ThroughResourcesStatement.ReadOnly
    ]] = AwsError.unwrapOptionField("throughResources", throughResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AccessScopePath
  ) extends zio.aws.ec2.model.AccessScopePath.ReadOnly {
    override val source: Optional[zio.aws.ec2.model.PathStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.ec2.model.PathStatement.wrap(value))
    override val destination
        : Optional[zio.aws.ec2.model.PathStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.ec2.model.PathStatement.wrap(value))
    override val throughResources
        : Optional[List[zio.aws.ec2.model.ThroughResourcesStatement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ThroughResourcesStatement.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AccessScopePath
  ): zio.aws.ec2.model.AccessScopePath.ReadOnly = new Wrapper(impl)
}
