package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcClassicLink(
    classicLinkEnabled: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcClassicLink = {
    import VpcClassicLink.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcClassicLink
      .builder()
      .optionallyWith(
        classicLinkEnabled.map(value => value: java.lang.Boolean)
      )(_.classicLinkEnabled)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcClassicLink.ReadOnly =
    zio.aws.ec2.model.VpcClassicLink.wrap(buildAwsValue())
}
object VpcClassicLink {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcClassicLink
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcClassicLink =
      zio.aws.ec2.model.VpcClassicLink(
        classicLinkEnabled.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def classicLinkEnabled: Optional[Boolean]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcId: Optional[String]
    def getClassicLinkEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("classicLinkEnabled", classicLinkEnabled)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcClassicLink
  ) extends zio.aws.ec2.model.VpcClassicLink.ReadOnly {
    override val classicLinkEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.classicLinkEnabled())
      .map(value => value: Boolean)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcClassicLink
  ): zio.aws.ec2.model.VpcClassicLink.ReadOnly = new Wrapper(impl)
}
