package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VolumeDetail(size: Long) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeDetail = {
    import VolumeDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeDetail
      .builder()
      .size(size: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeDetail.ReadOnly =
    zio.aws.ec2.model.VolumeDetail.wrap(buildAwsValue())
}
object VolumeDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VolumeDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeDetail =
      zio.aws.ec2.model.VolumeDetail(size)
    def size: Long
    def getSize: ZIO[Any, Nothing, Long] = ZIO.succeed(size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeDetail
  ) extends zio.aws.ec2.model.VolumeDetail.ReadOnly {
    override val size: Long = impl.size(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeDetail
  ): zio.aws.ec2.model.VolumeDetail.ReadOnly = new Wrapper(impl)
}
