package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{ThreadsPerCore, CoreCount, VCpuCount}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class VCpuInfo(
    defaultVCpus: Optional[VCpuCount] = Optional.Absent,
    defaultCores: Optional[CoreCount] = Optional.Absent,
    defaultThreadsPerCore: Optional[ThreadsPerCore] = Optional.Absent,
    validCores: Optional[Iterable[CoreCount]] = Optional.Absent,
    validThreadsPerCore: Optional[Iterable[ThreadsPerCore]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.VCpuInfo = {
    import VCpuInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VCpuInfo
      .builder()
      .optionallyWith(
        defaultVCpus.map(value => VCpuCount.unwrap(value): Integer)
      )(_.defaultVCpus)
      .optionallyWith(
        defaultCores.map(value => CoreCount.unwrap(value): Integer)
      )(_.defaultCores)
      .optionallyWith(
        defaultThreadsPerCore.map(value =>
          ThreadsPerCore.unwrap(value): Integer
        )
      )(_.defaultThreadsPerCore)
      .optionallyWith(
        validCores.map(value =>
          value.map { item =>
            CoreCount.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.validCores)
      .optionallyWith(
        validThreadsPerCore.map(value =>
          value.map { item =>
            ThreadsPerCore.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.validThreadsPerCore)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VCpuInfo.ReadOnly =
    zio.aws.ec2.model.VCpuInfo.wrap(buildAwsValue())
}
object VCpuInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VCpuInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VCpuInfo = zio.aws.ec2.model.VCpuInfo(
      defaultVCpus.map(value => value),
      defaultCores.map(value => value),
      defaultThreadsPerCore.map(value => value),
      validCores.map(value => value),
      validThreadsPerCore.map(value => value)
    )
    def defaultVCpus: Optional[VCpuCount]
    def defaultCores: Optional[CoreCount]
    def defaultThreadsPerCore: Optional[ThreadsPerCore]
    def validCores: Optional[List[CoreCount]]
    def validThreadsPerCore: Optional[List[ThreadsPerCore]]
    def getDefaultVCpus: ZIO[Any, AwsError, VCpuCount] =
      AwsError.unwrapOptionField("defaultVCpus", defaultVCpus)
    def getDefaultCores: ZIO[Any, AwsError, CoreCount] =
      AwsError.unwrapOptionField("defaultCores", defaultCores)
    def getDefaultThreadsPerCore: ZIO[Any, AwsError, ThreadsPerCore] =
      AwsError.unwrapOptionField("defaultThreadsPerCore", defaultThreadsPerCore)
    def getValidCores: ZIO[Any, AwsError, List[CoreCount]] =
      AwsError.unwrapOptionField("validCores", validCores)
    def getValidThreadsPerCore: ZIO[Any, AwsError, List[ThreadsPerCore]] =
      AwsError.unwrapOptionField("validThreadsPerCore", validThreadsPerCore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VCpuInfo
  ) extends zio.aws.ec2.model.VCpuInfo.ReadOnly {
    override val defaultVCpus: Optional[VCpuCount] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultVCpus())
      .map(value => zio.aws.ec2.model.primitives.VCpuCount(value))
    override val defaultCores: Optional[CoreCount] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultCores())
      .map(value => zio.aws.ec2.model.primitives.CoreCount(value))
    override val defaultThreadsPerCore: Optional[ThreadsPerCore] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultThreadsPerCore())
        .map(value => zio.aws.ec2.model.primitives.ThreadsPerCore(value))
    override val validCores: Optional[List[CoreCount]] = zio.aws.core.internal
      .optionalFromNullable(impl.validCores())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.CoreCount(item)
        }.toList
      )
    override val validThreadsPerCore: Optional[List[ThreadsPerCore]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validThreadsPerCore())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ThreadsPerCore(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VCpuInfo
  ): zio.aws.ec2.model.VCpuInfo.ReadOnly = new Wrapper(impl)
}
