package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class TransitGatewayMulticastDomain(
    transitGatewayMulticastDomainId: Optional[String] = Optional.Absent,
    transitGatewayId: Optional[String] = Optional.Absent,
    transitGatewayMulticastDomainArn: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    options: Optional[zio.aws.ec2.model.TransitGatewayMulticastDomainOptions] =
      Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayMulticastDomainState] =
      Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain = {
    import TransitGatewayMulticastDomain.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value => value: java.lang.String)
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(
        transitGatewayMulticastDomainArn.map(value => value: java.lang.String)
      )(_.transitGatewayMulticastDomainArn)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly =
    zio.aws.ec2.model.TransitGatewayMulticastDomain.wrap(buildAwsValue())
}
object TransitGatewayMulticastDomain {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayMulticastDomain =
      zio.aws.ec2.model.TransitGatewayMulticastDomain(
        transitGatewayMulticastDomainId.map(value => value),
        transitGatewayId.map(value => value),
        transitGatewayMulticastDomainArn.map(value => value),
        ownerId.map(value => value),
        options.map(value => value.asEditable),
        state.map(value => value),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayMulticastDomainId: Optional[String]
    def transitGatewayId: Optional[String]
    def transitGatewayMulticastDomainArn: Optional[String]
    def ownerId: Optional[String]
    def options: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.ReadOnly
    ]
    def state: Optional[zio.aws.ec2.model.TransitGatewayMulticastDomainState]
    def creationTime: Optional[DateTime]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayMulticastDomainId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getTransitGatewayMulticastDomainArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainArn",
        transitGatewayMulticastDomainArn
      )
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomainState
    ] = AwsError.unwrapOptionField("state", state)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain
  ) extends zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly {
    override val transitGatewayMulticastDomainId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayMulticastDomainId())
        .map(value => value: String)
    override val transitGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayId())
      .map(value => value: String)
    override val transitGatewayMulticastDomainArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayMulticastDomainArn())
        .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val options: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.wrap(value)
      )
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayMulticastDomainState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayMulticastDomainState.wrap(value)
        )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain
  ): zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly = new Wrapper(
    impl
  )
}
