package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyInstanceCapacityReservationAttributesRequest(
    instanceId: InstanceId,
    capacityReservationSpecification: zio.aws.ec2.model.CapacityReservationSpecification
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest = {
    import ModifyInstanceCapacityReservationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .capacityReservationSpecification(
        capacityReservationSpecification.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesRequest
      .wrap(buildAwsValue())
}
object ModifyInstanceCapacityReservationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesRequest =
      zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesRequest(
        instanceId,
        capacityReservationSpecification.asEditable
      )
    def instanceId: InstanceId
    def capacityReservationSpecification
        : zio.aws.ec2.model.CapacityReservationSpecification.ReadOnly
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getCapacityReservationSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.CapacityReservationSpecification.ReadOnly
    ] = ZIO.succeed(capacityReservationSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest
  ) extends zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val capacityReservationSpecification
        : zio.aws.ec2.model.CapacityReservationSpecification.ReadOnly =
      zio.aws.ec2.model.CapacityReservationSpecification
        .wrap(impl.capacityReservationSpecification())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest
  ): zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
