package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchTemplateCapacityReservationSpecificationResponse(
    capacityReservationPreference: Optional[
      zio.aws.ec2.model.CapacityReservationPreference
    ] = Optional.Absent,
    capacityReservationTarget: Optional[
      zio.aws.ec2.model.CapacityReservationTargetResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse = {
    import LaunchTemplateCapacityReservationSpecificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse
      .builder()
      .optionallyWith(capacityReservationPreference.map(value => value.unwrap))(
        _.capacityReservationPreference
      )
      .optionallyWith(
        capacityReservationTarget.map(value => value.buildAwsValue())
      )(_.capacityReservationTarget)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse
      .wrap(buildAwsValue())
}
object LaunchTemplateCapacityReservationSpecificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse =
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse(
        capacityReservationPreference.map(value => value),
        capacityReservationTarget.map(value => value.asEditable)
      )
    def capacityReservationPreference
        : Optional[zio.aws.ec2.model.CapacityReservationPreference]
    def capacityReservationTarget
        : Optional[zio.aws.ec2.model.CapacityReservationTargetResponse.ReadOnly]
    def getCapacityReservationPreference
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationPreference] =
      AwsError.unwrapOptionField(
        "capacityReservationPreference",
        capacityReservationPreference
      )
    def getCapacityReservationTarget: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationTargetResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationTarget",
      capacityReservationTarget
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse
  ) extends zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.ReadOnly {
    override val capacityReservationPreference
        : Optional[zio.aws.ec2.model.CapacityReservationPreference] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationPreference())
        .map(value =>
          zio.aws.ec2.model.CapacityReservationPreference.wrap(value)
        )
    override val capacityReservationTarget: Optional[
      zio.aws.ec2.model.CapacityReservationTargetResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationTarget())
      .map(value =>
        zio.aws.ec2.model.CapacityReservationTargetResponse.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse
  ): zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.ReadOnly =
    new Wrapper(impl)
}
