package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Ipv6PrefixSpecificationRequest(
    ipv6Prefix: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest = {
    import Ipv6PrefixSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest
      .builder()
      .optionallyWith(ipv6Prefix.map(value => value: java.lang.String))(
        _.ipv6Prefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.wrap(buildAwsValue())
}
object Ipv6PrefixSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ipv6PrefixSpecificationRequest =
      zio.aws.ec2.model
        .Ipv6PrefixSpecificationRequest(ipv6Prefix.map(value => value))
    def ipv6Prefix: Optional[String]
    def getIpv6Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Prefix", ipv6Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest
  ) extends zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly {
    override val ipv6Prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Prefix())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest
  ): zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly = new Wrapper(
    impl
  )
}
