package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InterfaceProtocolType {
  def unwrap: software.amazon.awssdk.services.ec2.model.InterfaceProtocolType
}
object InterfaceProtocolType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InterfaceProtocolType
  ): zio.aws.ec2.model.InterfaceProtocolType = value match {
    case software.amazon.awssdk.services.ec2.model.InterfaceProtocolType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InterfaceProtocolType.VLAN =>
      val r = VLAN
      r
    case software.amazon.awssdk.services.ec2.model.InterfaceProtocolType.GRE =>
      val r = GRE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InterfaceProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InterfaceProtocolType =
      software.amazon.awssdk.services.ec2.model.InterfaceProtocolType.UNKNOWN_TO_SDK_VERSION
  }
  case object VLAN extends zio.aws.ec2.model.InterfaceProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InterfaceProtocolType =
      software.amazon.awssdk.services.ec2.model.InterfaceProtocolType.VLAN
  }
  case object GRE extends zio.aws.ec2.model.InterfaceProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InterfaceProtocolType =
      software.amazon.awssdk.services.ec2.model.InterfaceProtocolType.GRE
  }
}
