package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceAttributeName {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceAttributeName
}
object InstanceAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceAttributeName
  ): zio.aws.ec2.model.InstanceAttributeName = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.INSTANCE_TYPE =>
      val r = instanceType
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.KERNEL =>
      val r = kernel
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.RAMDISK =>
      val r = ramdisk
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.USER_DATA =>
      val r = userData
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.DISABLE_API_TERMINATION =>
      val r = disableApiTermination
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR =>
      val r = instanceInitiatedShutdownBehavior
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.ROOT_DEVICE_NAME =>
      val r = rootDeviceName
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.BLOCK_DEVICE_MAPPING =>
      val r = blockDeviceMapping
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.PRODUCT_CODES =>
      val r = productCodes
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.SOURCE_DEST_CHECK =>
      val r = sourceDestCheck
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.GROUP_SET =>
      val r = groupSet
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.EBS_OPTIMIZED =>
      val r = ebsOptimized
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.SRIOV_NET_SUPPORT =>
      val r = sriovNetSupport
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.ENA_SUPPORT =>
      val r = enaSupport
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.ENCLAVE_OPTIONS =>
      val r = enclaveOptions
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAttributeName.DISABLE_API_STOP =>
      val r = disableApiStop
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object instanceType extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.INSTANCE_TYPE
  }
  case object kernel extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.KERNEL
  }
  case object ramdisk extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.RAMDISK
  }
  case object userData extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.USER_DATA
  }
  case object disableApiTermination
      extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.DISABLE_API_TERMINATION
  }
  case object instanceInitiatedShutdownBehavior
      extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR
  }
  case object rootDeviceName extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.ROOT_DEVICE_NAME
  }
  case object blockDeviceMapping
      extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.BLOCK_DEVICE_MAPPING
  }
  case object productCodes extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.PRODUCT_CODES
  }
  case object sourceDestCheck extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.SOURCE_DEST_CHECK
  }
  case object groupSet extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.GROUP_SET
  }
  case object ebsOptimized extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.EBS_OPTIMIZED
  }
  case object sriovNetSupport extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.SRIOV_NET_SUPPORT
  }
  case object enaSupport extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.ENA_SUPPORT
  }
  case object enclaveOptions extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.ENCLAVE_OPTIONS
  }
  case object disableApiStop extends zio.aws.ec2.model.InstanceAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAttributeName =
      software.amazon.awssdk.services.ec2.model.InstanceAttributeName.DISABLE_API_STOP
  }
}
