package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetHostReservationPurchasePreviewResponse(
    currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      Optional.Absent,
    purchase: Optional[Iterable[zio.aws.ec2.model.Purchase]] = Optional.Absent,
    totalHourlyPrice: Optional[String] = Optional.Absent,
    totalUpfrontPrice: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse = {
    import GetHostReservationPurchasePreviewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse
      .builder()
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(
        purchase.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.purchase)
      .optionallyWith(totalHourlyPrice.map(value => value: java.lang.String))(
        _.totalHourlyPrice
      )
      .optionallyWith(totalUpfrontPrice.map(value => value: java.lang.String))(
        _.totalUpfrontPrice
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse.ReadOnly =
    zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse
      .wrap(buildAwsValue())
}
object GetHostReservationPurchasePreviewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse =
      zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse(
        currencyCode.map(value => value),
        purchase.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalHourlyPrice.map(value => value),
        totalUpfrontPrice.map(value => value)
      )
    def currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues]
    def purchase: Optional[List[zio.aws.ec2.model.Purchase.ReadOnly]]
    def totalHourlyPrice: Optional[String]
    def totalUpfrontPrice: Optional[String]
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getPurchase
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Purchase.ReadOnly]] =
      AwsError.unwrapOptionField("purchase", purchase)
    def getTotalHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("totalHourlyPrice", totalHourlyPrice)
    def getTotalUpfrontPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("totalUpfrontPrice", totalUpfrontPrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse
  ) extends zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse.ReadOnly {
    override val currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val purchase: Optional[List[zio.aws.ec2.model.Purchase.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.purchase())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Purchase.wrap(item)
          }.toList
        )
    override val totalHourlyPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.totalHourlyPrice())
      .map(value => value: String)
    override val totalUpfrontPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.totalUpfrontPrice())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse
  ): zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse.ReadOnly =
    new Wrapper(impl)
}
