package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportTransitGatewayRoutesResponse(
    s3Location: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesResponse = {
    import ExportTransitGatewayRoutesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesResponse
      .builder()
      .optionallyWith(s3Location.map(value => value: java.lang.String))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ExportTransitGatewayRoutesResponse.ReadOnly =
    zio.aws.ec2.model.ExportTransitGatewayRoutesResponse.wrap(buildAwsValue())
}
object ExportTransitGatewayRoutesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ExportTransitGatewayRoutesResponse =
      zio.aws.ec2.model
        .ExportTransitGatewayRoutesResponse(s3Location.map(value => value))
    def s3Location: Optional[String]
    def getS3Location: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesResponse
  ) extends zio.aws.ec2.model.ExportTransitGatewayRoutesResponse.ReadOnly {
    override val s3Location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Location())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesResponse
  ): zio.aws.ec2.model.ExportTransitGatewayRoutesResponse.ReadOnly =
    new Wrapper(impl)
}
