package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeIamInstanceProfileAssociationsResponse(
    iamInstanceProfileAssociations: Optional[
      Iterable[zio.aws.ec2.model.IamInstanceProfileAssociation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse = {
    import DescribeIamInstanceProfileAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse
      .builder()
      .optionallyWith(
        iamInstanceProfileAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.iamInstanceProfileAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeIamInstanceProfileAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse =
      zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse(
        iamInstanceProfileAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def iamInstanceProfileAssociations: Optional[
      List[zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getIamInstanceProfileAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "iamInstanceProfileAssociations",
      iamInstanceProfileAssociations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse
  ) extends zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly {
    override val iamInstanceProfileAssociations: Optional[
      List[zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.iamInstanceProfileAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IamInstanceProfileAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse
  ): zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
