package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  PrefixListResourceId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayPrefixListReferenceRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    prefixListId: PrefixListResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest = {
    import DeleteTransitGatewayPrefixListReferenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayPrefixListReferenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest =
      zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest(
        transitGatewayRouteTableId,
        prefixListId
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def prefixListId: PrefixListResourceId
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest.ReadOnly =
    new Wrapper(impl)
}
