package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCustomerGatewayRequest(
    bgpAsn: Integer,
    publicIp: Optional[String] = Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent,
    `type`: zio.aws.ec2.model.GatewayType,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    deviceName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest = {
    import CreateCustomerGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest
      .builder()
      .bgpAsn(bgpAsn: java.lang.Integer)
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .`type`(`type`.unwrap)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateCustomerGatewayRequest.ReadOnly =
    zio.aws.ec2.model.CreateCustomerGatewayRequest.wrap(buildAwsValue())
}
object CreateCustomerGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCustomerGatewayRequest =
      zio.aws.ec2.model.CreateCustomerGatewayRequest(
        bgpAsn,
        publicIp.map(value => value),
        certificateArn.map(value => value),
        `type`,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deviceName.map(value => value)
      )
    def bgpAsn: Integer
    def publicIp: Optional[String]
    def certificateArn: Optional[String]
    def `type`: zio.aws.ec2.model.GatewayType
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def deviceName: Optional[String]
    def getBgpAsn: ZIO[Any, Nothing, Integer] = ZIO.succeed(bgpAsn)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getType: ZIO[Any, Nothing, zio.aws.ec2.model.GatewayType] =
      ZIO.succeed(`type`)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest
  ) extends zio.aws.ec2.model.CreateCustomerGatewayRequest.ReadOnly {
    override val bgpAsn: Integer = impl.bgpAsn(): Integer
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val `type`: zio.aws.ec2.model.GatewayType =
      zio.aws.ec2.model.GatewayType.wrap(impl.`type`())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val deviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest
  ): zio.aws.ec2.model.CreateCustomerGatewayRequest.ReadOnly = new Wrapper(impl)
}
