package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class ClientData(
    comment: Optional[String] = Optional.Absent,
    uploadEnd: Optional[DateTime] = Optional.Absent,
    uploadSize: Optional[Double] = Optional.Absent,
    uploadStart: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.ClientData = {
    import ClientData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientData
      .builder()
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .optionallyWith(uploadEnd.map(value => DateTime.unwrap(value): Instant))(
        _.uploadEnd
      )
      .optionallyWith(uploadSize.map(value => value: java.lang.Double))(
        _.uploadSize
      )
      .optionallyWith(
        uploadStart.map(value => DateTime.unwrap(value): Instant)
      )(_.uploadStart)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientData.ReadOnly =
    zio.aws.ec2.model.ClientData.wrap(buildAwsValue())
}
object ClientData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.ClientData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientData = zio.aws.ec2.model.ClientData(
      comment.map(value => value),
      uploadEnd.map(value => value),
      uploadSize.map(value => value),
      uploadStart.map(value => value)
    )
    def comment: Optional[String]
    def uploadEnd: Optional[DateTime]
    def uploadSize: Optional[Double]
    def uploadStart: Optional[DateTime]
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
    def getUploadEnd: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("uploadEnd", uploadEnd)
    def getUploadSize: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("uploadSize", uploadSize)
    def getUploadStart: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("uploadStart", uploadStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientData
  ) extends zio.aws.ec2.model.ClientData.ReadOnly {
    override val comment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: String)
    override val uploadEnd: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadEnd())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val uploadSize: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadSize())
      .map(value => value: Double)
    override val uploadStart: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadStart())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientData
  ): zio.aws.ec2.model.ClientData.ReadOnly = new Wrapper(impl)
}
